# 通知設計書 3-Syslog NOTICE通知（リロード）

## 概要

本ドキュメントは、Horse WebフレームワークのDaemonプロバイダーにおけるSyslog NOTICE通知（リロード）機能の設計を記述する。SIGHUPシグナル受信時に設定リロードの通知をシステムログに記録する機能である。

### 本通知の処理概要

本通知は、LinuxデーモンとしてHorseサーバーが動作中にSIGHUPシグナルを受信した際に、システムログファシリティを通じて設定リロード処理の開始を記録する機能を提供する。

**業務上の目的・背景**：Unix/Linuxの慣例として、SIGHUPシグナルはデーモンプロセスに設定ファイルの再読み込みを指示するために使用される。この通知により、システム管理者はsyslogを通じて設定リロードが実行されたことを確認でき、監視ツールによる設定変更の追跡やログ分析が可能となる。運用上、いつ設定が変更されたかを記録することは変更管理の重要な要素である。

**通知の送信タイミング**：デーモンプロセスがSIGHUPシグナルを受信した直後に送信される。シグナルハンドラ（HandleSignals関数）内で即座に実行される。

**通知の受信者**：システムログデーモン（syslogd/rsyslogd）を経由して、ログファイル（通常は`/var/log/daemon.log`または`/var/log/messages`）に記録される。受信者はシステム管理者、運用監視システム、ログ分析ツールである。

**通知内容の概要**：固定メッセージ「daemon: reloading config」が記録される。

**期待されるアクション**：システム管理者は設定リロードが実行されたことを確認できる。監視システムは設定変更イベントを記録し、変更履歴の追跡に活用する。

## 通知種別

システムログ（Syslog） - LOG_NOTICE優先度

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（シグナルハンドラ内） |
| 優先度 | NOTICE（LOG_NOTICE = 5） |
| リトライ | 無し |

### 送信先決定ロジック

syslogシステムコールにより、OSのシステムログデーモンに送信される。ログのルーティングはsyslog設定（`/etc/rsyslog.conf`等）に従う。ファシリティは`LOG_DAEMON`（デーモン関連メッセージ）が使用される。

## 通知テンプレート

### システムログ通知の場合

| 項目 | 内容 |
|-----|------|
| ファシリティ | LOG_DAEMON（3 << 3 = 24） |
| 優先度 | LOG_NOTICE（5） |
| オプション | LOG_PID \| LOG_NDELAY |
| 形式 | テキスト |

### 本文テンプレート

```
daemon: reloading config
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | システムログ通知のため添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| シグナル | SIGHUPシグナル受信 | 常に送信 | kill -HUP {pid} または systemctl reload等で発生 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非デーモンモード | HORSE_DAEMONが定義されていない場合は本コードは実行されない |
| シグナルハンドラ未登録 | fork処理前にエラーが発生した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SIGHUPシグナル受信] --> B[HandleSignals関数呼び出し]
    B --> C{SigNum判定}
    C -->|SIGHUP| D[Syslog LOG_NOTICE 送信]
    D --> E[daemon: reloading config]
    E --> F[シグナルハンドラ終了]
    C -->|SIGTERM| G[別の処理へ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 本通知はデータベースを使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知はデータベースを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| シグナルハンドラ内例外 | syslog送信失敗等 | シグナルハンドラ内では例外処理なし、OSに委ねる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（SIGHUPの受信頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

SIGHUPシグナル受信時に即座に送信される。時間帯の制限はない。

## セキュリティ考慮事項

- 固定メッセージのみをログに記録するため、機密情報の漏洩リスクはない
- シグナルハンドラ内でのsyslog呼び出しはシグナルセーフではない可能性があるが、実用上は問題なく動作することが多い
- syslogへの書き込み権限はOSレベルで管理される

## 備考

- `HORSE_DAEMON`コンパイラディレクティブが定義されている場合のみ有効
- 現在の実装では、ログ出力のみで実際の設定リロード処理は行われていない
- SIGHUPシグナルはUnix/Linuxの標準的なリロード指示であり、`kill -HUP {pid}`または`systemctl reload {service}`で送信される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シグナルハンドラとsyslog優先度の関係を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | LOG_NOTICE定数（行61、値=5）を確認 |
| 1-2 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | SIGHUPシグナル定数（Posix.Signalからインポート）を確認 |

**読解のコツ**: LOG_NOTICEは「正常だが重要な状態」を示す優先度。エラーではないが記録すべきイベントに使用される。

#### Step 2: エントリーポイントを理解する

シグナルハンドラの登録と処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | HandleSignals関数（行93-106）がシグナルハンドラ |
| 2-2 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | Signal(SIGHUP, HandleSignals)（行214）でハンドラ登録 |

**主要処理フロー**:
1. **行214**: `Signal(SIGHUP, HandleSignals)` - シグナルハンドラ登録
2. **行93-106**: HandleSignals関数
3. **行101-104**: SIGHUP受信時の処理
   - `Syslog(LOG_NOTICE, 'daemon: reloading config')` - **ここがNOTICE通知の送信箇所**

#### Step 3: シグナル処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | case文によるシグナル種別判定（行95-105） |

**主要処理フロー**:
- **行95**: `case SigNum of` - シグナル番号による分岐
- **行96-100**: SIGTERM処理（別の通知）
- **行101-104**: SIGHUP処理（本通知）
  - `Syslog(LOG_NOTICE, 'daemon: reloading config')`

### プログラム呼び出し階層図

```
[OSカーネル] - SIGHUPシグナル送信
    │
    ▼
HandleSignals (行93, cdecl宣言のシグナルハンドラ)
    │
    ├─ case SigNum of (行95)
    │      │
    │      ├─ SIGTERM: (行96-100)
    │      │      └─ FRunning := False
    │      │         FEvent.SetEvent
    │      │
    │      └─ SIGHUP: (行101-104)
    │             │
    │             └─ Syslog(LOG_NOTICE, 'daemon: reloading config')
    │                    │
    │                    └─ ThirdParty.Posix.Syslog.Syslog (行88)
    │                           │
    │                           └─ _syslog (libc外部関数)
    │
    └─ [ハンドラ終了、通常処理に復帰]

[シグナルハンドラ登録部分]
THorseProvider.InternalListen (行195)
    │
    └─ Signal(SIGHUP, HandleSignals) (行214)
           │
           └─ Posix.Signal.Signal (libc外部関数)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

SIGHUPシグナル     ───▶ HandleSignals関数          ───▶ syslog
(kill -HUP pid)            │                              /var/log/daemon.log
                           ▼
                    case SigNum of SIGHUP
                           │
                           ▼
                    固定メッセージ生成
                    "daemon: reloading config"
                           │
                           ▼
                    Syslog(LOG_NOTICE, message)
                           │
                           ▼
                    _syslog(LOG_NOTICE, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | ソース | デーモンプロバイダーのメイン実装、シグナルハンドラ定義 |
| ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | ソース | syslog APIのDelphiラッパー、LOG_NOTICE定数定義 |
| Posix.Signal | （システムユニット） | ソース | Signal関数、SIGHUP/SIGTERM定数定義 |
